#version 330 core
out vec4 FragColor;
  
in vec2 texCoord;
#define TexCoords texCoord

uniform sampler2D image;
  
uniform bool horizontal;
float weight[5] = float[5](0.227027, 0.1945946, 0.1216216, 0.054054, 0.016216);

uniform float testvalue;

void main()
{             
    vec2 tex_offset = 1.0 / textureSize(image, 0); // gets size of single texel
    vec3 result = texture(image, TexCoords).rgb * weight[0]; // current fragment's contribution
    if(horizontal)
    {
        for(int i = 1; i < 5; ++i)
        {
            result += texture(image, clamp(TexCoords + vec2(tex_offset.x * i, 0.0),tex_offset.x,1.0-tex_offset.x)).rgb * weight[i];
            result += texture(image, clamp(TexCoords - vec2(tex_offset.x * i, 0.0),tex_offset.x,1.0-tex_offset.x)).rgb * weight[i];
        }
    }
    else
    {
        for(int i = 1; i < 5; ++i)
        {
            result += texture(image, clamp(TexCoords + vec2(0.0, tex_offset.y * i),tex_offset.y,1.0-tex_offset.y)).rgb * weight[i];
            result += texture(image, clamp(TexCoords - vec2(0.0, tex_offset.y * i),tex_offset.y,1.0-tex_offset.y)).rgb * weight[i];
        }
    }

	//vec4 original = texture(image, TexCoords);
    //FragColor = (vec4(result, 1.0)+vec4(result, 1.0)*vec4(0.6,0.85,1.3,1.0)/20.0/30.0)*1.0031*1.3;
    FragColor = vec4(result, 1.0);
}

/*
in vec2 texCoord;

uniform sampler2D colorMap;

uniform vec4 glColor;

uniform float testvalue;


void main (void)
{
	//gl_FragColor = texture2D(colorMap, texCoord)*glColor;

	const float xpixelsize = 1.0/1920.0;
	const float ypixelsize = 1.0/1080.0;
	vec4 col = vec4(0,0,0,0);
	float blursize = 12.0-3.4;
	blursize/=2.0;
	if (blursize<1) blursize = 1;
	int counter = 0;
	for (float y=-blursize/2; y<=blursize/2; y++){
		for (float x=-blursize/2; x<=blursize/2; x++){
			vec2 uv=texCoord+vec2(x*xpixelsize,y*ypixelsize);
			uv.x=clamp(uv.x,2.0/1920.0,1.0-2.0/1920.0);
			uv.y=clamp(uv.y,2.0/1080.0,1.0-2.0/1080.0);
			col+=texture2D(colorMap, uv);
			counter++;
		}
	}
	col/=counter;
	//col/=1.3*1.2;
	gl_FragColor = col;;
}
*/